@extends('app.base')
@section('content')
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="javascript:;" onclick="history.back()" class="headerButton goBack">
                <ion-icon name="chevron-back-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            {{!empty($categoria->titulo) ? $categoria->titulo : 'Anuncios'}}
        </div>
        <div class="right">
            <a href="{{ route('app.filtros') }}" class="headerButton">
                <ion-icon name="search-outline"></ion-icon>
            </a>
        </div>
    </div>
    <div id="appCapsule">
        <div class="section full">
            <ul class="listview image-listview media search-result mb-2" id="result">
                @foreach ($anuncios as $anuncio)
                <li>
                    <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$anuncio->id)}}', '_self')"  class="item">
                        @if (!empty($anuncio->thumb))
                            <div class="imageWrapper">
                                <img src="{{ url("storage/{$anuncio->thumb}") }}" class="imaged corta-img">
                            </div>
                        @endif
                        <div class="in">
                            <div>
                                <h4 style="margin-top: -20px;" class="mb-05">{{lmWord($anuncio->empresa, 30)}}</h4>
                                <div class="text-muted">
                                    {{!empty($anuncio->categoria->titulo) ? $anuncio->categoria->titulo : ''}} {{!empty($anuncio->sub) ? '- '.$anuncio->sub->titulo : ''}}<br>
                                    {{!empty($anuncio->bairro) ? $anuncio->bairro.', ': ''}} {{$anuncio->cidade}}-{{$anuncio->estado}}
                                    <div class="mt-05"><strong>Publicado em: {{ date('d/m/Y', strtotime($anuncio->created_at))}}</strong></div>
                                 </div>
                            </div>
                        </div>
                    </a>
                </li>
               @endforeach

               @foreach ($free as $anuncio)
                <li>
                    <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$anuncio->id)}}', '_self')"  class="item">
                        @if (!empty($anuncio->thumb))
                            <div class="imageWrapper">
                                <img src="{{ url("storage/{$anuncio->thumb}") }}" class="imaged corta-img">
                            </div>
                        @endif
                        <div class="in">
                            <div>
                                <h4 style="margin-top: -20px;" class="mb-05">{{lmWord($anuncio->empresa, 30)}}</h4>
                                <div class="text-muted">
                                    {{$anuncio->categoria->titulo}} {{!empty($anuncio->sub) ? '- '.$anuncio->sub->titulo : ''}}<br>
                                    {{!empty($anuncio->bairro) ? $anuncio->bairro.', ': ''}} {{$anuncio->cidade}}-{{$anuncio->estado}}
                                    <div class="mt-05"><strong>Publicado em: {{ date('d/m/Y', strtotime($anuncio->created_at))}}</strong></div>
                                </div>
                            </div>
                        </div>
                    </a>
                </li>
               @endforeach
            </ul>
        </div>
    </div>
@endsection
